#ifndef _MS3_PAINTER_
#define _MS3_PAINTER_

class Painter
{
  public:
    //constructor
    Painter(Options options_);
    //destructor
    ~Painter();
    //interface
    void drawGrid();
    void drawDigitAt(int x, int y, int digit);
    void drawFlagAt(int x, int y);
    void drawHiddenTileAt(int x, int y);
    void drawHiddenTileAt(int x, int y, int phase);
    void showMine(int x, int y);
    void showKillerMine(int x, int y);
    void showFalseMine(int x, int y);
    void showFace(int phase);
    void showFace(std::string face, int phase);
    void writeFlags(int number);
    void writeTime(int number);
  private:
    //internal functions
    int getWindowWidth();
    int getWindowHeight();
    int writeBlackNumber(int number, int x);
    //internal window data
    Options options;
    SDL_Surface * screen;
    const int screenBPP;
    const int tileSize;
    SDL_Surface * tileset;
    int flags;
    int time;
    string current_face;
};

#endif
