#include <cmath>
#include <sstream>
#include <vector>

using std::istringstream;
using std::string;
using std::vector;

#include "SDL/SDL.h"

#include "tile.h"
#include "options.h"
#include "painter.h"
#include "game.h"

short GetNumber(std::string argument) {
  istringstream s(argument);
  short integer;
  s >> integer;
  return integer;
}

int main(int argc, char * argv[])
{
  SDL_Init(SDL_INIT_VIDEO);
  
  //Options: rows, columns, mines, cheat
  Options beginner = {9, 9, 10, false};
  Options intermediate = {16, 16, 40, false};
  Options expert = {16, 30, 99, false};
  //End Options

  //CLI
  vector<string> arguments;
  Options cli_options;
  cli_options = expert;
  if (argc > 1) {
    for (int count = 1; count < argc; count++) {
      arguments.resize(count);
      arguments[count-1] += argv[count];
      if (arguments[count-1].substr(0,5) == "mode=") {
        if (arguments[count-1].substr(5) == "beginner")
          cli_options = beginner;
        if (arguments[count-1].substr(5) == "intermediate")
          cli_options = intermediate;
        if (arguments[count-1].substr(5) == "expert")
          cli_options = expert;
      }
      if (arguments[count-1].substr(0,6) == "width=")
        cli_options.columns = GetNumber(arguments[count-1].substr(6)) > 9
                ? GetNumber(arguments[count-1].substr(6)) : 9;
      if (arguments[count-1].substr(0,7) == "height=")
        cli_options.rows = GetNumber(arguments[count-1].substr(7)) > 9
                ? GetNumber(arguments[count-1].substr(6)) : 9;
      if (arguments[count-1].substr(0,6) == "mines=")
        cli_options.mines = GetNumber(arguments[count-1].substr(6)) <
                (cli_options.rows * cli_options.columns) - 1 ?
                GetNumber(arguments[count-1].substr(6)) :
                (cli_options.rows * cli_options.columns) / 5;
      if (arguments[count-1] == "cheat=true")
        cli_options.cheat = true;
    }
  }
  //End CLI

  Game game = Game(cli_options);

  //Program loop
  const int tileSize = 14;
  int x, y = 0;
  bool quit = false;
  SDL_Event event;
  bool lmbdown = false; //lmb = left mouse button
  bool rmbdown = false;   //rmb = right mouse button
  while (quit == false)
  {
    x = static_cast<int> (floor(event.button.x / tileSize));
    y = static_cast<int> (floor( (event.button.y - tileSize) / tileSize));
    SDL_WaitEvent(&event);
    switch(event.type)
    {
      case SDL_QUIT:
        quit = true;
        break;
      case SDL_KEYDOWN:
        switch(event.key.keysym.sym) 
        {
          case SDLK_F2:
            game.newGame();
            break;
          case SDLK_n:
            game.newGame();
            break;
          case SDLK_b:
            game.newGame(beginner);
            break;
          case SDLK_i:
            game.newGame(intermediate);
            break;
          case SDLK_e:
            game.newGame(expert);
            break;
          case SDLK_q:
            quit = true;
            break;
          case SDLK_ESCAPE:
            quit = true;
            break;
        }
        break;
      case SDL_MOUSEMOTION:
        game.setCursorPos(x, y);
        break;
      case SDL_MOUSEBUTTONDOWN:
        if (event.button.button == SDL_BUTTON_LEFT)
          lmbdown = true;
        else if (event.button.button == SDL_BUTTON_RIGHT)
          rmbdown = true;
        break;
      case SDL_MOUSEBUTTONUP:
        if (lmbdown == true && rmbdown == true)
          game.clearTilesAround(x, y);
        else if (event.button.button == SDL_BUTTON_LEFT)
        {
          if (game.gameStarted() == false)
            game.generateMinesFrom(x, y);
          game.clearTileAt(x, y);
        }
        else if (event.button.button == SDL_BUTTON_RIGHT)
          game.setFlagAt(x, y);
        lmbdown = false;
        rmbdown = false;
        break;
    }
  }
  //End Program loop

  SDL_Quit();
}
