#ifndef _MS3_GAME_
#define _MS3_GAME_

int timer(void * data);

class Game
{
  public:
    //constructor
    Game(Options options_);
    //destructor
    ~Game();
    //interface
    void clearTileAt(int x, int y);
    void setFlagAt(int x, int y);
    void clearTilesAround(int x, int y);
    void generateMinesFrom(int x, int y);
    //control
    bool gameIsOver() const;
    bool gameStarted() const;
    void newGame();
    void newGame(Options options_);
    //thread control
    void setCursorPos(int x, int y) const;
  private:
    //internal functions
    int countAdjacentMinesAt(int x, int y) const;
    int countAdjacentFlagsAt(int x, int y) const;
    void clearAdjacentTilesAt(int x, int y);
    void showAllMines(int x, int y);
    //internal game data
    vector< vector< Tile > > grid;
    Options options;
    bool started;
    bool gameover;
    SDL_Thread * timerthread;
    SDL_Thread * faderthread;
    int flags;
};

#endif
