#include <iostream>
#include <vector>

using std::string;
using std::vector;

#include "SDL/SDL.h"
#include "SDL/SDL_thread.h"

#include "options.h"
#include "tile.h"
#include "painter.h"
#include "game.h"

//global variables (for both threads)

Painter * painter = NULL;

//global variables (for timer thread)

int seconds = 0;
bool ttrunning = false;

//global variables (for fader thread)

int phase = 0;
bool ftrunning = true;
bool countup = true;
int cursor_x = -1;
int cursor_y = -1;
bool onnewgameicon = false;
Tile tile = {false, false, false};

//external functions

int random(int min, int max)
{
  //generate random number and put it in desired range
  int range = (max + 1) - min;
  int random_number = rand() % range;
  random_number += min;
  //return random number
  return random_number;
}

int timer(void * data)
{
  while (ttrunning == true && seconds < 1000)
  {
    painter->writeTime(seconds);
    seconds++;
    SDL_Delay(1000);
  }
}

int fader(void * data)
{
  while (true)
  {
    if (ftrunning == true && tile.hidden == true && tile.flagged == false)
      painter->drawHiddenTileAt(cursor_x, cursor_y, phase);
    if (phase == 0 && countup == false)
      countup = true;
    else if (phase == 9 && countup == true)
      countup = false;
    if (countup == true)
      phase++;
    else if (countup == false)
      phase--;
    SDL_Delay(80);
  }
}

//constructor

Game::Game(Options options_):
  options(options_),
  started(false),
  gameover(false),
  flags(0),
  timerthread(NULL)
{
  grid.resize(options.columns);
  for (int i = 0; i < options.columns; i++)
  {
    grid[i].resize(options.rows);
    for (int j = 0; j < grid[i].size(); j++)
    {
      grid[i][j].hidden = true;
      grid[i][j].mined = false;
      grid[i][j].flagged = false;
    }
  }
  painter = new Painter(options_);
  painter->drawGrid();
  faderthread = SDL_CreateThread(fader, NULL);
}

Game::~Game()
{
  delete painter;
  SDL_KillThread(timerthread);
  SDL_KillThread(faderthread);
}

//interface

void Game::clearTileAt(int x, int y)
{
  tile.hidden = false;
  if (y < options.rows)
  {
    if (grid[x][y].hidden == true &&
            grid[x][y].flagged == false &&
            gameover == false)
    {
      grid[x][y].hidden = false;
      if (grid[x][y].mined == true)
      {
        //lose game
        gameover = true;
        showAllMines(x, y);
        painter->showFace(":(", 0);
        ftrunning = false;
        ttrunning = false;
      }
      else
      {
        painter->drawDigitAt(x, y, countAdjacentMinesAt(x, y));;
        if (countAdjacentMinesAt(x, y) == 0)
          clearAdjacentTilesAt(x, y);
      }
    }
    //check if player won
    unsigned short int hiddentiles = 0;
    for (int i=0; i<options.columns; i++)
    {
      for (int j=0; j<options.rows; j++)
      {
        if (grid[i][j].hidden == true)
          hiddentiles++;
      }
    }
    if (hiddentiles == options.mines)
    {
      gameover = true;
      painter->showFace("8D", 0);
      ftrunning = false;
      ttrunning = false;
    }
  }
  //newgame icon
  else if (y == options.rows && x == 3)
    newGame();
}

void Game::setFlagAt(int x, int y)
{
  tile.flagged = true;
  if (grid[x][y].hidden == true && gameover == false)
  {
    if (grid[x][y].flagged == false)
    { //tile is not flagged => flag it
      grid[x][y].flagged = true;
      painter->drawFlagAt(x, y);
      flags++;
      painter->writeFlags(flags);
    }
    else
    { //tile is already flagged => unflag it
      grid[x][y].flagged = false;
      painter->drawHiddenTileAt(x, y);
      flags--;
      painter->writeFlags(flags);
    }
  }
}

void Game::clearTilesAround(int x, int y)
{
  if (countAdjacentFlagsAt(x, y) == countAdjacentMinesAt(x, y)
    && grid[x][y].hidden == false)
  {
    for (int i = (x == 0 ? 0 : -1); i <= ((x+1) == options.columns ? 0 : 1); i++)
      for (int j = (y == 0 ? 0 : -1); j <= ((y+1) == options.rows ? 0 : 1); j++)
        clearTileAt(x + i, y + j);
  }
}

void Game::generateMinesFrom(int x, int y)
{
  srand((unsigned)time(NULL));
  int rand_x, rand_y;
  for (int i=0; i<options.mines; i++) {
    int rand_x = random(0, options.columns - 1);
    int rand_y = random(0, options.rows - 1);
    if (grid[rand_x][rand_y].mined == true || (x == rand_x && y == rand_y))
      i--;
    else
    {
      grid[rand_x][rand_y].mined = true;
      if (options.cheat == true)
        painter->showMine(rand_x, rand_y);
    }
  }
  started = true;
  ttrunning = true;
  timerthread = SDL_CreateThread(timer, NULL);
}

//control

bool Game::gameIsOver() const
{
  return gameover;
}

bool Game::gameStarted() const
{
  return started;
}

void Game::newGame()
{
  newGame(options);
}

void Game::newGame(Options options_)
{
  if (ttrunning == true)
    SDL_KillThread(timerthread);
  SDL_KillThread(faderthread);
  seconds = 0;
  ftrunning = true;
  faderthread = SDL_CreateThread(fader, NULL);
  options = options_;
  delete painter;
  painter = new Painter(options_);
  started = false;
  gameover = false;
  flags = 0;
  grid.resize(options.columns);
  for (int i = 0; i < options.columns; i++)
  {
    grid[i].resize(options.rows);
    for (int j = 0; j < grid[i].size(); j++)
    {
      grid[i][j].hidden = true;
      grid[i][j].mined = false;
      grid[i][j].flagged = false;
    }
  }
  painter->drawGrid();
}

//thread control

void Game::setCursorPos(int x, int y) const
{
  //no change
  if (cursor_x == x && cursor_y == y)
    ;
  //newgame icon
  else if (x == 3 && y == options.rows)
  {
    painter->showFace(1);
    onnewgameicon = true;
  }
  else if (onnewgameicon == true)
  {
    painter->showFace(0);
    onnewgameicon = false;
  }
  //out of range
  else if (x < 0 || x > options.columns || y < 0 || y >= options.rows)
    ;
  //changed tile
  else
  {
    if (ftrunning == true && tile.hidden == true && tile.flagged == false)
      painter->drawHiddenTileAt(cursor_x, cursor_y);
    cursor_x = x;
    cursor_y = y;
    tile = grid[x][y];
  }
}

//internal functions

int Game::countAdjacentMinesAt(int x, int y) const
{
  int minesnear = 0;
  for (int i = (x == 0 ? 0 : -1); i <= ((x+1) == options.columns ? 0 : 1); i++)
    for (int j = (y == 0 ? 0 : -1); j <= ((y+1) == options.rows ? 0 : 1); j++)
      if (grid[x+i][y+j].mined == true)
        minesnear++;
  return minesnear;
}

int Game::countAdjacentFlagsAt(int x, int y) const
{
  int flagsnear = 0;
  for (int i = (x == 0 ? 0 : -1); i <= ((x+1) == options.columns ? 0 : 1); i++)
    for (int j = (y == 0 ? 0 : -1); j <= ((y+1) == options.rows ? 0 : 1); j++)
      if (grid[x+i][y+j].flagged == true)
        flagsnear++;
  return flagsnear;
}

void Game::clearAdjacentTilesAt(int x, int y)
{
  for (int i = (x == 0 ? 0 : -1); i <= ((x+1) == options.columns ? 0 : 1); i++)
    for (int j = (y == 0 ? 0 : -1); j <= ((y+1) == options.rows ? 0 : 1); j++)
      clearTileAt(x + i, y + j);
}

void Game::showAllMines(int x, int y)
{
  for (int i = 0; i < options.columns; i++)
  {
    for (int j = 0; j < grid[i].size(); j++)
    {
      if (grid[i][j].mined == true && grid[i][j].flagged == false)
      {
        if (i == x && j == y)
          painter->showKillerMine(i, j);
        else
          painter->showMine(i, j);
      }
      else if (grid[i][j].mined == false && grid[i][j].flagged == true)
        painter->showFalseMine(i, j);
    }
  }
}
