#include <iostream>
#include <vector>
#include <cmath>

#include "SDL/SDL.h"

#include "options.h"
#include "tile.h"
#include "window.h"
#include "game.h"
#include "session.h"

Session::Session(Options options):
  current_options(options),
  leftmousebuttondown(false),
  rightmousebuttondown(false),
  mouseovernewgameicon(false)
{
  current_game = new Game(options);
}

Session::~Session()
{
  delete current_game;
}

void Session::newGame()
{
  delete current_game;
  current_game = new Game(current_options);
}

void Session::newGame(Options options)
{
  delete current_game;
  current_game = new Game(options);
  current_options = options;
}

void Session::handleLeftMouseButtonDown(unsigned short int x, unsigned short int y)
{
  leftmousebuttondown = true;
  if (x == 3 && y == current_options.rows)
    current_game->gamewindow->writeInBlack(3, "S");
  else if (current_game->gameIsOver() == false)
  {
    current_game->updateHoverTile(x, y, leftmousebuttondown);
    current_game->gamewindow->writeInBlack(3, "R");
  }
}

void Session::handleLeftMouseButtonUp(unsigned short int x, unsigned short int y)
{
  leftmousebuttondown = false;
  if (current_game->gameIsOver() == false)
    current_game->gamewindow->writeInBlack(3, "U");
  if (rightmousebuttondown == true)
    current_game->handleDoubleClick(x, y);
  else if (x == 3 && y == current_options.rows)
    newGame();
  else
  {
    if (current_game->started == false) {
      current_game->generateMines(x, y);
      current_game->started = true;
      current_game->time_started = SDL_GetTicks();
    }
    current_game->clearTileAt(x, y);
  }
}

void Session::handleRightMouseButtonDown(unsigned short int x, unsigned short int y)
{
  rightmousebuttondown = true;
}

void Session::handleRightMouseButtonUp(unsigned short int x, unsigned short int y)
{
  rightmousebuttondown = false;
  if (leftmousebuttondown == true)
  {
    current_game->handleDoubleClick(x, y);
    current_game->gamewindow->writeInBlack(3, "U");
  }
  else
    current_game->setFlagAt(x, y);
}

void Session::handleMouseMotion(unsigned short int x, unsigned short int y)
{
  //newgame icon
  if (x == 3 && y == current_options.rows)
  {
    if (mouseovernewgameicon == false)
    {
      mouseovernewgameicon = true;
      current_game->gamewindow->writeInBlack(3, "V");
    }
  }
  else
  {
    //hovertile on minefield/grid
//    if (y >= 0 && y < current_options.rows)
//      Menu::
    //game menu
    //if (y == 0 && x <= 21) [...]
    current_game->updateHoverTile(x, y, leftmousebuttondown);
    //newgame icon
    if (mouseovernewgameicon == true)
    {
      mouseovernewgameicon = false;
      if (current_game->gameIsOver() == false)
        current_game->gamewindow->writeInBlack(3, "U");
      else
      {
        if (current_game->won == true)
          current_game->gamewindow->writeInBlack(3, "W");
        else
          current_game->gamewindow->writeInBlack(3, "T");
      }
    }
  }
}
