#ifndef _MS2_GAME_H_
#define _MS2_GAME_H_

class Menu
{
  public:
    Menu(std::string name, std::string options, unsigned short int x,
            SDL_Surface *screen);
    void showMenu();
    void hideMenu();
    void hoverMenuOption();
    void unHoverMenuOption();
    void writeChar(unsigned short int x, unsigned short int y,
            SDL_Surface *screen, char character);
    void writeString(unsigned short int x, unsigned short int y,
            SDL_Surface *screen, std::string text);
    SDL_Rect getCoords();
  private:
    std::string menu_name;
    std::vector<std::string> menu_options;
    SDL_Surface *menufont;
    SDL_Surface *hoverfont;
    SDL_Rect menu_button_coords;
    short unsigned int menu_width; //in pixels
    short unsigned int menu_height; //in pixels
    static const short unsigned int FONT_WIDTH = 5;
    static const short unsigned int FONT_HEIGHT = 14;
};

#endif
