#include <iostream>
#include <vector>
#include <cmath>

#include "SDL/SDL.h"
#include "SDL/SDL_image.h"

#include "options.h"
#include "window.h"
#include "menu.h"

Menu::Menu(std::string name, std::string options, unsigned short int x,
        SDL_Surface *screen):
  menu_name(name)
{
  //populate options vector
  std::string this_option = "";
  menu_options.resize(1);
  for (int i=0; i<options.length(); i++)
  {
    if (options[i] == ',')
    {
      menu_options.resize( menu_options.size() + 1 );
      menu_options[menu_options.size()-1] = this_option;
      this_option = "";
    }
    else
      this_option += options[i];
  }
  //determine menu width
  unsigned short int longest_option = 0;
  for (int i=0; i<menu_options.size(); i++)
  {
    if (menu_options[i].length() > longest_option)
      longest_option = menu_options[i].length();
  }
  menu_width = longest_option * FONT_WIDTH;
  //determine menu height
  menu_height = menu_options.size()* FONT_HEIGHT;
  //load fonts
  SDL_Surface *tempimg = IMG_Load("menufont.bmp");
  menufont = SDL_DisplayFormat(tempimg);
  tempimg = IMG_Load("hoverfont.bmp");
  hoverfont = SDL_DisplayFormat(tempimg);
  //set menu coordinates
  menu_button_coords.x = x;
  menu_button_coords.y = 0;
  menu_button_coords.w = menu_width;
  menu_button_coords.h = FONT_HEIGHT;
  //show menu at the top
  writeString(x, 0, screen, name);
}

void Menu::showMenu()
{

}

void Menu::hideMenu()
{

}

void Menu::hoverMenuOption()
{

}

void Menu::unHoverMenuOption()
{

}

SDL_Rect Menu::getCoords()
{

}

void Menu::writeChar(unsigned short int x, unsigned short int y,
        SDL_Surface* screen, char character)
{
  const unsigned short int ascii = static_cast<unsigned short int> (character);
  SDL_Rect dstrec;
  dstrec.x = x * FONT_WIDTH;
  dstrec.y = y * FONT_HEIGHT;
  SDL_Rect srcrec;
  unsigned short int temp = static_cast<unsigned short int> ( floor( ascii / 16 ) );
  srcrec.y = temp * FONT_HEIGHT;
  srcrec.x = ( ascii - (temp * 16) ) * FONT_WIDTH;
  srcrec.w = FONT_WIDTH;
  srcrec.h = FONT_HEIGHT;
  SDL_BlitSurface(menufont, &srcrec, screen, &dstrec);
  SDL_Flip(screen);
}

void Menu::writeString(unsigned short int x, unsigned short int y,
        SDL_Surface *screen, std::string text)
{
  for (int i=0; i<text.length(); i++)
    writeChar(x+i, y, screen, text[i]);
}
