#ifndef _MS2_GAME_H_
#define _MS2_GAME_H_

class Game
{
  public:
    Game(Options options);
    ~Game();
    void updateHoverTile(unsigned short int x, unsigned short int y,
            bool leftmousebuttondown);
    void clearTileAt(unsigned short int x, unsigned short int y);
    void setFlagAt(unsigned short int x, unsigned short int y);
    void generateMines(unsigned short int x, unsigned short int y);
    void handleDoubleClick(unsigned short int x, unsigned short int y);
    void showCurrentTime();
    bool gameIsOver();
    bool started;
    Window *gamewindow;
    unsigned int time_started;
    bool won;
  private:
    void initImages();
    void initGrid();
    void loseGame(unsigned short int x, unsigned short int y);
    void winGame();
    const unsigned short int countAdjacentMinesAt(unsigned short int x,
            unsigned short int y);
    const unsigned short int showAdjacentMinesAt(unsigned short int x,
            unsigned short int y);
    const unsigned short int countAdjacentFlagsAt(unsigned short int x,
            unsigned short int y);
    void clearAdjacentTilesAt(unsigned short int x, unsigned short int y);
    const Options gameoptions;
    bool gameover;
    static const unsigned short int FONT_SIZE = 14;
    std::vector< std::vector<Tile> > grid;
    SDL_Surface *font1;
    SDL_Rect hover_tile;
    unsigned short int flags;
};

#endif
